<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\LoanEnquiries;
use Illuminate\Support\Facades\Response;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Models\PushNotification;
use App\Models\User;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;
use PDF;
class QRCodeController extends Controller
{
    public function generateQRCode(Request $request)
    {
        // $data = User::where('employeeID', 'BW613675')->first();

        // $pdf = PDF::loadView('qrcode', compact('qrCode'));
        // return $pdf->download('visiting-card');
        // Retrieve the logged-in employee's ID
   //  $employeeId = auth()->user()->employeeID;
   $employeeId = 'BW613675';
        // Generate a URL with the employee ID
     $url = route('enquiries', ['employee_id' =>  $employeeId]);

        // Generate the QR code with the URL
    $qrCode = QrCode::size(200)->generate($url);
   // $qrCode = QrCode::format('png')->size(200)->generate($url);
        // Return the QR code as a response or view
     // return view('qrcode', compact('qrCode'));
     $pdf = PDF::loadView('qrcode', compact('qrCode'));
     return $pdf->download('qrcode');


      $view = view('qrcode', compact('qrCode'))->render();
      return response()->json([
        'html' => $view
    ]);
     // return response($qrCode, 200);
    //  ->header('Content-Type', 'image/png');
      
    }

    public function downloadQRCode(Request $request)
    {
       
        // Retrieve the logged-in employee's ID
    $employeeId = auth()->user()->employeeID;
   // $employeeId = 'BW613675';
        // Generate a URL with the employee ID
     $url = route('enquiries', ['employee_id' =>  $employeeId]);

      // Specify the storage path
    // $filePath = storage_path('app/public/qrcode_ '.$employeeId.'.svg');

    //     // Generate the QR code with the URL
    // $qrCode = QrCode::size(300)->generate($url, $filePath);
   
    
        // Return the QR code as a response or view
   //   return  response()->download($url);
   return response()->json(
    array(
        'status' => True,
        'url' => $url
    ),
    200
);
      
    }

    public function saveEnquiries(Request $request)
    {
        $res = LoanEnquiries::insert([
            'name' => $request->name,
            'mobile_number' => $request->phone,
            'service' => $request->service,
            'district' => $request->district,
            'employee_id' => $request->employee_id,
        ]);

        $firebaseToken = User::where('employeeID',$request->employee_id)->pluck('device_token')->first();

        $notification = new PushNotification;
        $notification->title =  "New Loan Application Submitted by ".$request->name;
        $notification->message = $request->name . " submit a loan application for ".$request->service;
        $notification->agent_id = User::where('employeeID',$request->employee_id)->pluck('id')->first();
        $res = $notification->save(); 

            $data = [
               'token' => $firebaseToken,
                "notification" => [
                    "title" => "New Loan Application Submitted by ".$request->name,
                    "body" => $request->name . " submit a loan application for ".$request->service,
                ]
            ];
            $SERVER_API_KEY = env('FCM_SERVER_KEY');

            $dataString = json_encode($data);
            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);
            curl_close($ch);
        if ($res == 1) {
           // return view("success");
         return redirect()->route('success');
        } else {
            return back()->with('error', "Something Wrong");
        }
    }
    public function getLoanEnquiries(Request $request)
    {
        $res = LoanEnquiries::where('employee_id' , auth()->user()->employeeID)->get();

        if (count($res)>0) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $res,
                    'message' => "Success"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => [],
                    'message' => "No Data Available"
                ),
                200
            );
        }
    }
    public function enquiries(Request $request)
    {
        return view('enquires', ['employee_id' => $request->employee_id]);
    }

    public function changeLoanEnquiriesStatus(Request $request)
    {
        $res = LoanEnquiries::where('id' , $request->loan_id)->update(['status'=>$request->status]);

        if ($res==1) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => "Status Updated Successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => "Something went wrong"
                ),
                200
            );
        }
    }
}
